//Illustrator図版のindd上の索引マーキング用　2020.12.28〜2022.08.18　（z-）
//aiドキュメント内のテキストを配置先inddドキュメント（なければ新規）のアクティブページに移植するやつ
//
//　注意点
//座標のみ保持します。書体とかサイズは再現なし
//アウトラインは拾わないので作字とか注意
//印刷しない・乗算　がかかります
//スウォッチ "C=0 M=0 Y=100 K=0" を使用します。なければ作られます。
//アクティブページのアクティブレイヤー上に出力されるので事前に注意してください。
//アクティブアートボードの左上が原点となります。
//ムダに広いアートボードで実行するとinddのすごい端っこに置かれたりするので注意。

#target illustrator
#targetengine "aitoindd"

var doc = app.activeDocument;
var tfAry = [];
var pi = doc.pageItems;
var ar = doc.artboards[doc.artboards.getActiveArtboardIndex()].artboardRect;
doc.rulerOrigin = [0, ar[1] - ar[3]]; //ドキュメント定規のリセット

for(var i = 0; i < pi.length; i++){
    if(pi[i].reflect.name == "TextFrame"){
        tfAry.push(pi[i]);
        }
    }

for(i = 0; i < tfAry.length; i++){
    var tf = tfAry[i];
    sendToIndd({left: mm(tf.left), top: mm(tf.top), contents: tf.textRange.contents.replace(/[\n\r]/g, "＼r"), bounds: tf.geometricBounds}.toSource());
    }

function sendToIndd(info){
    var bt = new BridgeTalk();
    bt.target = "indesign-14.064";
    bt.body = uneval(inddAction) + "(" + info + ")";
    bt.send();
    }

function inddAction(info){
    try{
        var gb = [info.bounds[1], info.bounds[0], info.bounds[3], info.bounds[2]];
        var doc = app.documents.length? app.activeDocument : app.documents.add();
        var pg = doc.layoutWindows[0].activePage;
        var tf = pg.textFrames.add(doc.activeLayer, undefined, undefined, {geometricBounds: gb});
        with(tf.textFramePreferences){
            /*autoSizingReferencePoint = AutoSizingReferenceEnum.TOP_LEFT_POINT;*/
            insetSpacing = "1mm";
            }
        if(doc.swatches.itemByName("C=0 M=0 Y=100 K=0").isValid == false){
            var myFillColor = doc.colors.add();
            myFillColor.colorValue = [0, 0, 100, 0];
            myFillColor.name = "C=0 M=0 Y=100 K=0";
            }
        with(tf){
            textWrapPreferences.textWrapMode = TextWrapModes.NONE;
            fillColor = doc.swatches.itemByName("C=0 M=0 Y=100 K=0");
            nonprinting = true;
            move([info.left, -info.top]);
            contents = info.contents.replace(/＼r/g, String.fromCharCode(0xd));
            fit(FitOptions.FRAME_TO_CONTENT);
            transparencySettings.blendingSettings.blendMode = BlendMode.MULTIPLY;
            paragraphs.everyItem().gridAlignment = GridAlignment.NONE;
            select(SelectionOptions.ADD_TO);
            }
        } catch(e){alert(e);}
    }

function mm(pt){
    return pt * (25.4 / 72);
    }
